/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.validation;

import eu.europa.ec.taxud.cesop.domain.ValidationError;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorType;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorTypeEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationErrorTypeHolder;
import eu.europa.ec.taxud.cesop.validation.CesopTooManyErrorsException;
import java.util.ArrayList;
import java.util.Collection;

class CesopValidationErrorList
extends ArrayList<ValidationError> {
    private static final long serialVersionUID = -6195714947208497354L;
    private boolean exceeded;
    private final int maxCapacity;

    public CesopValidationErrorList(int maxCapacity) {
        if (maxCapacity <= 0) {
            throw new IllegalArgumentException("Cannot create a list with negative or null capacity");
        }
        this.maxCapacity = maxCapacity;
    }

    @Override
    public boolean add(ValidationError validationError) {
        if (this.exceeded) {
            throw new CesopTooManyErrorsException("Validation error list reached maximum capacity");
        }
        super.add(validationError);
        if (this.size() >= this.maxCapacity) {
            super.add(this.onExceed(validationError));
            this.exceeded = true;
            throw new CesopTooManyErrorsException("Validation error list reached maximum capacity");
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ValidationError> validationErrors) {
        for (ValidationError validationError : validationErrors) {
            this.add(validationError);
        }
        return true;
    }

    private ValidationError onExceed(ValidationError exceedingError) {
        ValidationErrorType validationErrorType = ValidationErrorTypeHolder.INSTANCE.findByCode(ValidationErrorTypeEnum.CM_TR_0080.getCode());
        ValidationError validationError = new ValidationError(ValidationErrorTypeEnum.CM_TR_0080);
        validationError.setErrorShortDesc(validationErrorType.getDescription());
        validationError.setErrorLongDesc(validationErrorType.getLongDescription());
        validationError.setMessageRefId(exceedingError.getMessageRefId());
        validationError.setErrorCounter(1);
        return validationError;
    }
}

